package com.mmc.payment.model.qo;

import com.mmc.payment.common.publicinterface.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/29 15:59
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.qo.RepoAccountQO", description = "云仓账号信息查询QO")
public class UserCashQO implements Serializable {

    private static final long serialVersionUID = -3425378226992206841L;
    @ApiModelProperty(value = "用户名称/手机号/UID")
    private String userMassage;

    @ApiModelProperty(value = "页码", required = true, example = "1")
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;
    @ApiModelProperty(value = "每页显示数", required = true, example = "10")
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }

    @ApiModelProperty(value = "用户ID", hidden = true)
    private List<Integer> accountIds;


}
