package com.mmc.payment.model.qo;

import com.mmc.payment.common.publicinterface.Page;
import com.mmc.payment.config.UserPorts;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/5/23 19:13
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.qo.RepoAccountQO", description = "云仓账号信息查询QO")
public class RepoAccountQO implements Serializable {

    private static final long serialVersionUID = -3425378226992206841L;
    @ApiModelProperty(value = "关键字")
    private String keyword;
    @ApiModelProperty(value = "实名认证状态")
    private Integer realAuthStatus;
    @ApiModelProperty(value = "企业认证状态")
    private Integer entAuthStatus;
    @ApiModelProperty(value = "用户类型")
    private Integer accountType;
    @ApiModelProperty(value = "注册开始时间")
    private Date startTime;
    @ApiModelProperty(value = "注册结束时间")
    private Date endTime;
    @ApiModelProperty(value = "是否渠道")
    private Integer channelAuthStatus;
    @ApiModelProperty(value = "渠道等级")
    private Integer channelClass;
    @ApiModelProperty(value = "是否销售")
    private Integer sale;
    @ApiModelProperty(value = "是否白名单")
    private Integer white;
    @ApiModelProperty(value = "用户来源：0自然流，1海报，2抖音，3公众号，4社群，5招投标，默认0")
    private Integer source;
    @ApiModelProperty(value = "用户ID", hidden = true)
    private List<Integer> accountIds;
    @ApiModelProperty(value = "多端用户，USER_PORT(云享飞)-FLYER_PORT(云飞手)-REPO_PORT(云仓)")
    private Set<String> ports;
    @ApiModelProperty(value = "多端用户（差集），USER_PORT(云享飞)-FLYER_PORT(云飞手)-REPO_PORT(云仓)", hidden = true)
    private Set<String> eports;
    @ApiModelProperty(value = "推荐单位ID")
    private Integer rcdCompanyId;
    @ApiModelProperty(value = "单位ID", hidden = true)
    private List<Integer> companys;
    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;
    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }

    public void buildEports() {
        if (!CollectionUtils.isEmpty(this.ports)) {
            this.eports = UserPorts.ports.stream().filter(d -> !this.ports.contains(d)).collect(Collectors.toSet());
        }
    }
}
