package com.mmc.payment.entity.repo;

import com.mmc.payment.model.dto.repo.RepoWalletDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/23 20:30
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RepoWalletDO implements Serializable {
    private static final long serialVersionUID = 6230679407746486112L;
    private Integer id;
    private Integer repoAccountId;
    private BigDecimal cashAmt;
    private BigDecimal cashPaid;
    private BigDecimal cashFreeze;
    private BigDecimal rcdRebateAmt;
    private BigDecimal rebateWdl;
    private BigDecimal rebateFreeze;
    private String remark;
    private Date updateTime;
    private Date createTime;
    private String phoneNum;
    private String userName;
    private String nickName;
    private Integer portType;
    private String uid;

    public void initWallet(Integer repoAccountId) {
        this.repoAccountId = repoAccountId;
        this.cashAmt = BigDecimal.ZERO;
        this.cashPaid = BigDecimal.ZERO;
        this.cashFreeze = BigDecimal.ZERO;
        this.createTime = new Date();
    }

    public RepoWalletDTO buildRepoWalletDTO() {
        return RepoWalletDTO.builder().id(this.id).
                repoAccountId(this.repoAccountId).
                cashAmt(this.cashAmt).
                cashPaid(this.cashPaid).
                cashFreeze(this.cashFreeze)
                .userName(this.userName)
                .uid(this.uid)
                .nickName(this.nickName)
                .phoneNum(this.phoneNum).
                        portType(this.portType).
                        remark(this.remark).build();
    }

   /* public RepoRebateSubDTO buildRepoRebateSubDTO(){
        RepoRebateSubDTO repoRebateSubDTO = RepoRebateSubDTO.builder().repoAccountId(this.repoAccountId).rcdRebateAmt(this.rcdRebateAmt)
                .rebateFreeze(this.rebateFreeze).rebateWdl(this.rebateWdl).build();
        repoRebateSubDTO.computerTotalRebate();
        return repoRebateSubDTO;
    }*/
}
