package com.mmc.payment.config;

import com.mmc.payment.common.Tenant;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * @Author small
 * @Date 2023/5/29 10:38
 * @Version 1.0
 */
@Slf4j
public class TenantContext {

    private static ThreadLocal<Tenant> tenantHolder = new ThreadLocal<>();

    public static void setTenant(Tenant tenant) {
        tenantHolder.set(tenant);
    }

    public static Tenant getTenant() {
        return tenantHolder.get();
    }

    public static Integer getUserId() {
        return getTenant().getUserId();
    }

    public static Integer getTenantId() {
        return getTenant().getTenantId();
    }

    public static Integer getRoleId() {
        return getTenant().getRoleId();
    }


    public static boolean exists() {
        return getTenant() != null;
    }

    public static void clear() {
        tenantHolder.remove();
    }

    public static Tenant buildTenant( String accountNo ) {


        if (StringUtils.isBlank(accountNo)) {
            log.error("登录信息[accountNo]获取异常");
            return null;
        }
        return new Tenant(accountNo);
    }

    /**
     * valid tenantId is correct
     */
    private static boolean validNumeric(String number) {
        return StringUtils.isNotEmpty(number) && StringUtils.isNumeric(number);
    }


}
