package com.mmc.oms.model.dto.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/6/3 20:22
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.mall.dto.OrderGoodsIndstProdListDTO", description = "行业规格对应产品清单DTO")
public class OrderGoodsIndstProdListDTO implements Serializable {
    private static final long serialVersionUID = -1838976151472371521L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "行业订单规格id")
    private Integer orderGoodsIndstDetailId;
    @ApiModelProperty(value = "产品类型名称")
    private String goodsTypeName;
    @ApiModelProperty(value = "产品名称")
    private String productName;
    @ApiModelProperty(value = "型号")
    private String model;
    @ApiModelProperty(value = "品牌")
    private String productBrand;
    @ApiModelProperty(value = "产品规格id")
    private Integer productSpecId;
    @ApiModelProperty(value = "产品规格名称")
    private String prodSkuSpecName;
    @ApiModelProperty(value = "产品规格图片")
    private String prodSkuSpecImage;
    @ApiModelProperty(value = "料号")
    private String partNo;
    @ApiModelProperty(value = "版本描述")
    private String versionDesc;
    @ApiModelProperty(value = "购买数量")
    private Integer buyNum;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "单位名称-产品规格")
    private String unitName;
}