package com.mmc.oms.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.entity.coupon.CouponUserDO;
import com.mmc.oms.model.dto.coupon.CouponUserDTO;
import com.mmc.oms.model.dto.coupon.CouponUserOrderDTO;
import com.mmc.oms.model.dto.order.OrderCouponDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.vo.coupon.CouponUserExchangeVO;
import com.mmc.oms.model.vo.coupon.CouponUserVO;

import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 14:45
 * @Version 1.0
 */
public interface CouponUserService extends IService<CouponUserDO> {

    /**
     * 查询我的优惠券
     *
     * @param status         优惠券状态 1：已使用, 2:已失效，3:已转赠
     * @param pageNo         页码
     * @param pageSize       每页数
     * @param currentAccount 用户信息
     * @return
     */
    ResultBody getMyList(Integer status, Integer pageNo, Integer pageSize, BaseAccountDTO currentAccount);

    /**
     * 领取优惠券
     *
     * @param id             优惠券id
     * @param currentAccount 用户信息
     * @return
     */
    ResultBody receiveCoupon(Integer id, BaseAccountDTO currentAccount);

    /**
     * 批量领取优惠券
     *
     * @param id             优惠券id
     * @param currentAccount 用户信息
     * @return
     */
    ResultBody receiveCouponList(List<Integer> id, BaseAccountDTO currentAccount);


    /**
     * 转增优惠券
     *
     * @param id  优惠券
     * @param uid 用户uid
     * @return
     */
    ResultBody presentedCoupon(Integer id, String uid, BaseAccountDTO currentAccount);

    /**
     * 获取可领取优惠券列表
     *
     * @param priority 品牌id,搜索品牌指定优惠卷
     * @param pageNo   页码
     * @param pageSize 每页数
     * @return
     */
    ResultBody getList(List<Integer> priority, Integer pageNo, Integer pageSize, BaseAccountDTO currentAccount);


    /**
     * 根据品牌获取可用优惠券
     *
     * @param primaryKey 品牌id
     * @param uid        用户信息
     * @return
     */
    List<CouponUserOrderDTO> getUsableCoupon(List<Integer> primaryKey, Integer uid);

    /**
     * 根据id获取我的优惠券详情
     *
     * @param couponId id
     * @return
     */
    List<CouponUserDTO> feignGetById(List<Integer> couponId);


    /**
     * 下单修改我的优惠券
     *
     * @param couponUserVO 优惠券记录表修改VO
     * @return
     */
    Boolean feignUpMyCoupon(List<CouponUserVO> couponUserVO);

    Boolean feignExchangeCoupon(CouponUserExchangeVO couponUserExchangeVO);

    /**
     * 优惠券定时过期任务
     */
    void overdueTask();

    List<CouponUserOrderDTO> feignListUserCouponsByIds(List<Integer> couponIds);

    List<CouponUserDTO> feignOrderCoupon(String orderNumber);

    /**
     * 优惠券回退
     *
     * @param orderCouponDTOS
     * @return
     */
    Boolean feignRollbackCoupons(List<OrderCouponDTO> orderCouponDTOS);

    ResultBody couponMerchandise(Integer couponId, String productName, Integer useType);

    ResultBody couponUsageDetails(Integer uid);
}
