package com.mmc.oms.model.vo.uav;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2023/8/8 10:48
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PriceStockVO implements Serializable {

    private static final long serialVersionUID = 1011141620995647903L;
    @ApiModelProperty(value = "id", example = "1")
    private Integer id;

    @ApiModelProperty(value = "商品规格", example = "示例：{\"颜色\":\"蓝色\",\"尺寸\":\"1寸\",\"大小\":\"小\"} 或 [\"颜色\":\"蓝色\",\"尺寸\":\"1寸\",\"大小\":\"小\"] 或 你怎么方便怎么来")
    private String productSpec;

    @ApiModelProperty(value = "销售价格", example = "1")
    private BigDecimal salePrice;

    @ApiModelProperty(value = "sku图片", example = "https://pad-video-x.oss-cn-shenzhen.aliyuncs.com/file/35bbd044-7cd7-4c85-ba27-69776e03dbb2.jpg")
    private String skuImage;

    @ApiModelProperty(value = "渠道价格", example = "1")
    private BigDecimal channelPrice;

    @ApiModelProperty(value = "库存", example = "10")
    private Integer stock;

    @ApiModelProperty(value = "sku编号", example = "mmc-da-s-b")
    private String skuNo;

}
