package com.mmc.oms.controller.uav;

import com.mmc.oms.common.publicinterface.Page;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.feign.UserAppApi;
import com.mmc.oms.model.dto.uav.UavCartCompanyDTO;
import com.mmc.oms.model.dto.uav.UavCartDTO;
import com.mmc.oms.model.dto.uav.UavOrderDTO;
import com.mmc.oms.model.qo.uav.UavCartQO;
import com.mmc.oms.model.vo.uav.UavCartVO;
import com.mmc.oms.service.uav.UavCartService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;

/**
 * @description: 商城购物车，正常订单可以多商家的商品一起下单；意向订单只能单个商家的商品一起下单。
 * @author: zj
 * @Date: 2023/9/16 14:37
 */
@Api(tags = { "最新版-购物车接口" })
@RestController
@RequestMapping("/uav-cart/")
public class UavCartController extends BaseController {
    @Autowired
    private UavCartService uavCartService;

    @ApiOperation(value = "加入购物车")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("add")
    public ResultBody addCart(@RequestBody UavCartVO uavCartVO) {
        return uavCartService.addCart(uavCartVO);
    }

    @ApiOperation(value = "移除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("batchRemove")
    public ResultBody batchRemove(@RequestBody List<Integer> carIds) {
        return uavCartService.batchRemove(carIds);
    }

    @ApiOperation(value = "修改数量")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("updateNum")
    public ResultBody updateNum(@RequestParam(required = true) Integer id,
                             @ApiParam("改变的数量（正加负减）") @RequestParam(required = true) Integer changeNum, HttpServletRequest request) {
        return uavCartService.updateNum(id, changeNum);
    }

    @ApiOperation(value = "购物车列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UavCartCompanyDTO.class)})
    @PostMapping("list")
    public ResultBody list(@Validated(Page.class) @RequestBody UavCartQO uavCartQO,
                           HttpServletRequest request) {
        return uavCartService.list(uavCartQO, this.getCurrentAccount(request));
    }
}
