package com.mmc.oms.service.uav;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.qo.uav.UavOrderQO;
import com.mmc.oms.model.vo.uav.AddUavOrderVO;
import com.mmc.oms.model.vo.uav.UavOrderExpressVO;
import com.mmc.oms.model.vo.uav.UavOrderPayVO;
import com.mmc.oms.model.vo.uav.UavOrderRemarkVO;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/9/4 15:31
 */
public interface UavOrderService {
    ResultBody addOrder(AddUavOrderVO param, BaseAccountDTO currentAccount);

    ResultBody detail(Integer id) throws Exception;

    ResultBody close(Integer id);

    ResultBody list(UavOrderQO uavOrderQO, BaseAccountDTO currentAccount);

    ResultBody listByUid(UavOrderQO uavOrderQO, BaseAccountDTO currentAccount);

    ResultBody pay(Integer id, BaseAccountDTO currentAccount, HttpServletRequest request);

    ResultBody send(UavOrderExpressVO param);

    ResultBody receive(Integer id);

    ResultBody remarkOrder(UavOrderRemarkVO uavOrderRemarkVO);

    ResultBody sellerRemark(Integer id, String content);

    ResultBody statusList();

    ResultBody upLoadPay(UavOrderPayVO uavOrderPayVO);

    ResultBody checkPay(UavOrderPayVO uavOrderPayVO);
}
