package com.mmc.oms.model.vo.uav;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/9/4 16:01
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AddUavOrderVO implements Serializable {
    private static final long serialVersionUID = 2749055915508197141L;
    @ApiModelProperty("商家id")
    private Integer thirdBackUserAccountId;
    @ApiModelProperty("卖家企业名称")
    private String companyName;
    @ApiModelProperty("商品id")
    private Integer mallGoodsId;
    @ApiModelProperty("收货地址")
    private Integer userAddressId;
    @ApiModelProperty("订单类型，0正常直接支付订单，1意向沟通订单")
    private Integer orderType;
    @ApiModelProperty("订单实付总额")
    private BigDecimal orderTotalAmount;
    @ApiModelProperty("抵扣钱包余额")
    private BigDecimal walletAmount;
    @ApiModelProperty("抵扣云享金余额")
    private BigDecimal shareAmount;
    @ApiModelProperty("其他方式支付额度")
    private BigDecimal otherAmount;
    @ApiModelProperty("用户备注")
    private String userRemark;
    @ApiModelProperty("规格列表")
    private List<UavOrderSkuVO> skuVOS;
}
