package com.mmc.oms.model.dto.ware;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author small @Date 2023/5/26 13:18 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.dto.WareInfoItemDTO", description = "商品列表ItemDTO")
public class WareInfoItemDTO implements Serializable {
    private static final long serialVersionUID = -4354269497656808831L;

    @ApiModelProperty(value = "ID")
    private Integer id;

    @ApiModelProperty(value = "商品编号")
    private String wareNo;

    @ApiModelProperty(value = "商品标题")
    private String wareTitle;

    @ApiModelProperty(value = "商品类型ID")
    private Integer wareTypeId;

    @ApiModelProperty(value = "商品状态")
    private Integer wareStatus;

    @ApiModelProperty(value = "最小押金")
    private BigDecimal minDeposit;

    @ApiModelProperty(value = "最小租金")
    private BigDecimal minRent;

    @ApiModelProperty(value = "总库存数量")
    private Integer totalStock;

    @ApiModelProperty(value = "总销量")
    private Integer totalSale;

    @ApiModelProperty(value = "商品活动属性Id")
    private Integer propInfoId;

    @ApiModelProperty(value = "生成时间")
    private Date createTime;

    @ApiModelProperty(value = "商品图片")
    private List<WareImgDTO> wareImgs;

    @ApiModelProperty(value = "标签集合")
    private List<String> tags;
}
