package com.mmc.oms.model.dto.uav;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/4 14:55
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "用户支付信息")
public class UavOrderPayDTO implements Serializable {
    private static final long serialVersionUID = 7429924736182755541L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "订单id")
    private Integer uavOrderId;
    @ApiModelProperty(value = "支付凭证")
    private String payImgList;
    @ApiModelProperty(value = "审核状态，0待审批，1通过，2未通过")
    private Integer checkStatus;
    @ApiModelProperty(value = "备注信息")
    private String payRemark;
    @ApiModelProperty(value = "未通过原因")
    private String refuseReason;
    @ApiModelProperty(value = "提交时间")
    private Date createTime;
}
