package com.mmc.oms.model.dto.uav;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/9/4 14:52
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "收货地址")
public class UavOrderExpressDTO implements Serializable {
    private static final long serialVersionUID = 6025905100022602806L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "订单id")
    private Integer uavOrderId;
    @ApiModelProperty(value = "快递编号")
    private String sendExpNo;
    @ApiModelProperty(value = "快递编码")
    private String sendExpCode;
    @ApiModelProperty(value = "取货人")
    private String takeName;
    @ApiModelProperty(value = "取货人号码")
    private String takePhone;
    @ApiModelProperty(value = "地区信息")
    private String takeRegion;
    @ApiModelProperty(value = "发货-收货详细地址")
    private String takeAddress;
    @ApiModelProperty(value = "取件时间")
    private Date receiveTime;
    @ApiModelProperty(value = "是否已取件，0未取，1已取")
    private Integer receive;

}
