package com.mmc.oms.controller.demand.commit;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.dao.demand.DemandReleaseOrderDao;
import com.mmc.oms.entity.demand.GetOrderNumberDO;
import com.mmc.oms.entity.demand.GetOrderNumberDTO;
import com.mmc.oms.model.vo.demand.CommonPaymentVO;
import com.mmc.oms.model.vo.demand.UserPayInfoVO;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @Author small
 * @Date 2023/8/26 16:13
 * @Version 1.0
 */
@Slf4j
@Component
@Aspect
public class NotRepeatSubmitConfig extends BaseController {
    @Autowired
    private RedissonClient redissonClient;

    @Autowired
    private DemandReleaseOrderDao releaseOrderDao;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${payment.url}")
    private String paymentApp;


    @Pointcut("@within(notRepeatSubmit)||@annotation(notRepeatSubmit)")
    public void pointcut(NotRepeatSubmit notRepeatSubmit) {

    }

    @Around(value = "pointcut(notRepeatSubmit)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, NotRepeatSubmit notRepeatSubmit) throws Throwable {
        log.info("提交之前---");
        Object result = null;
        long leaseTime = notRepeatSubmit.value();
        log.info("leaseTime:" + leaseTime);

        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Integer userAccountId = this.getCurrentAccount(request).getUserAccountId();

        String accountUriLockKey = userAccountId + "-" + request.getServletPath();
        // 设置锁定资源名称，accountUriLock改为userid+uri作为标识，作为测试写死
        //   String accountUriLockKey = "accountUriLock";

        RLock accountUriLock = redissonClient.getLock(accountUriLockKey);
        boolean tryLock;

        MethodSignature signature = (MethodSignature) proceedingJoinPoint.getSignature();
        Method method = signature.getMethod();
        String name = method.getDeclaringClass().getName();
        String[] parameterNames = signature.getParameterNames();

        Map<String, Object> map = new HashMap<String, Object>();
        Object[] values = proceedingJoinPoint.getArgs();
        String[] names = ((CodeSignature) proceedingJoinPoint.getSignature()).getParameterNames();
        for (int i = 0; i < names.length; i++) {
            map.put(names[i], values[i]);
        }
        log.info(map+"");
        CommonPaymentVO commonPaymentsVO = (CommonPaymentVO) map.get("commonPaymentVO");

        //尝试获取分布式锁
        //-1为永久  leaseTime 最多等待几秒   上锁以后leaseTime秒自动解锁
        tryLock = accountUriLock.tryLock(-1, leaseTime, TimeUnit.MILLISECONDS);
        log.info("tryLock:" + tryLock);
        if (tryLock) {
            try {
              String orderNumber = commonPaymentsVO.getOrderNumber();
                String json = stringRedisTemplate.opsForValue().get(orderNumber);
                GetOrderNumberDTO getOrderNumberDTO = JSONObject.parseObject(json, GetOrderNumberDTO.class);
                    if (getOrderNumberDTO!=null){
                        GetOrderNumberDO getOrderNumberDO = new GetOrderNumberDO(getOrderNumberDTO);
                        if (getOrderNumberDTO.getRequirementsInfoId()!=null){
                            String orderNumber1 = releaseOrderDao.getOrderNumber(getOrderNumberDO.getRequirementsInfoId());
                            if (orderNumber1!=null){
                                UserPayInfoVO userPayInfoVO = queryUserPayInfo(orderNumber1, request);
                                if (!userPayInfoVO.getTradeState().equals("SUCCESS")){
                                  releaseOrderDao.getDelete(getOrderNumberDO.getRequirementsInfoId());
                                }
                            }
                            int i = releaseOrderDao.selectOrderNumberDO(getOrderNumberDO.getRequirementsInfoId());
                            if (i!=0){
                                return ResultBody.error("当前需求已有人支付");
                            }
                        }
                    }
                // 查询订单库存判断是否大于0
                //                大于0表示还有库存可以更新订单库存将库存数字减一更新到数据库中
                //        不大于0表示没有库存了本次请求就终止
                log.info("正常提交：");
                result = proceedingJoinPoint.proceed();
            } catch (Exception e) {
                log.info("主程序异常：" + e);
                throw new Exception(e);
            }
        } else {
            log.info("重复提交：" + accountUriLockKey);
        }
        log.info("提交之后---");
        return result;

    }



    /**
     * 通过订单编号查看是否支付成功
     *
     * @param orderNo
     * @return
     */
    public UserPayInfoVO queryUserPayInfo(String orderNo, HttpServletRequest request) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(orderNo), headers);
        ResponseEntity<UserPayInfoVO> exchange = restTemplate.exchange(paymentApp + "wechat/queryUserPayInfo?orderNo=" + orderNo, HttpMethod.GET, entity, UserPayInfoVO.class);
        UserPayInfoVO body = exchange.getBody();
        return body;
    }

}

