package com.mmc.oms.model.dto.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 14:46
 * @Version 1.0
 */
@Builder
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
//@ApiModel(value="CouponUser对象", description="下单可用用户优惠券DTO表")
@NoArgsConstructor
@AllArgsConstructor
public class CouponUserOrderDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "优惠券id")
    private Integer couponId;

    @ApiModelProperty(value = "订单id")
    private Long cid;

    @ApiModelProperty(value = "领取人id")
    private Integer uid;

    @ApiModelProperty(value = "领取人手机号码")
    private String userPhone;

    @ApiModelProperty(value = "优惠券名称")
    private String couponName;

    @ApiModelProperty(value = "优惠券类型 1打折券, 2减免券 3无门槛")
    private Integer couponType;

    @ApiModelProperty(value = "优惠券使用类型 1vip券, 2品牌券")
    private Integer useType;

    @ApiModelProperty(value = "优惠券的面值")
    private BigDecimal couponMoney;

    @ApiModelProperty(value = "最低消费")
    private BigDecimal minPrice;

    @ApiModelProperty(value = "优惠券的折扣")
    private BigDecimal couponDiscount;

    @ApiModelProperty(value = "剩余余额")
    private BigDecimal remainingBalance;

    @ApiModelProperty(value = "获取方式，1 后台发放, 2 用户领取, 3赠送 4获赠")
    private String gainType;

    @ApiModelProperty(value = "状态（0：未使用,1：已使用, 2:已失效,3:已转赠,4:使用中）")
    private Integer status;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "开始使用时间")
    private Date startTime;

    @ApiModelProperty(value = "过期时间")
    private Date endTime;

    @ApiModelProperty(value = "使用时间")
    private Date useTime;

    @ApiModelProperty(value = "所属品牌id")
    private String primaryKey;

    @ApiModelProperty(value = "是否多次核销 0单次核销 1多次核销")
    private Boolean verificationType;

    @ApiModelProperty(value = "最多优惠")
    private BigDecimal preferentialLimit;

    @ApiModelProperty(value = "有效状态：usable-可用，unusable-不可用，默认不可用")
    private String validStr;

    @ApiModelProperty(value = "所属品牌id")
    private List<String> brandIds;

    @ApiModelProperty(value = "可打折金额")
    private BigDecimal discountCouponPrice;

    @ApiModelProperty(value = "推荐使用")
    private Integer recommend;

}
