package com.mmc.oms.controller.data;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.model.dto.data.OrderReportDTO;
import com.mmc.oms.service.data.OrderReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author LW
 * @date 2023/9/16 17:49
 * 概要：
 */
@Api(tags = "云享飞加盟入驻及商品sku看板数据")
@RequestMapping("/product/report")
@RestController
public class OrderReportController {


    @Autowired
    private OrderReportService orderReportService;

    @ApiOperation(value = "获取用户报表数据")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = OrderReportDTO.class)})
    @GetMapping("/getOrderReportData")
    public ResultBody<OrderReportDTO> getOrderReportData() {
        return orderReportService.getOrderReportData();
    }

}
