package com.mmc.oms.mq.listener;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.dao.topup.TopUpOrderDao;
import com.mmc.oms.entity.topup.TopUpOrderDO;
import com.mmc.oms.feign.UserAppApi;
import com.mmc.oms.model.vo.wallet.TopUpOrderVO;
import com.mmc.oms.mq.constant.RabbitmqConstant;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/6/29 10:35 概要：
 */
@Slf4j
@Component
public class MqConsumer {
    @Resource
    TopUpOrderDao topUpOrderDao;
    @Resource
    UserAppApi userAppApi;

    @RabbitListener(queues = RabbitmqConstant.USER_TOP_UP_DIRECT_QUEUE)
    public void subscribeFanoutQueue(@Payload String topUpOrder, Channel channel, Message message) {
        TopUpOrderVO topUpOrderVO = JSONObject.parseObject(topUpOrder, TopUpOrderVO.class);
        log.info("==========用户充值====>用户充值消费者消费开始：订单信息是---->{}", topUpOrderVO);
        // 根据消费的消息修改充值订单的信息
        TopUpOrderDO topUpOrderDO = new TopUpOrderDO();
        topUpOrderDO.setTradeState(topUpOrderVO.getTradeState());
        topUpOrderDO.setTradeStateDesc(topUpOrderVO.getTradeStateDesc());
        topUpOrderDO.setOrderNo(topUpOrderVO.getOrderNo());
        topUpOrderDao.updateTopUpOrderInfo(topUpOrderDO);
        if ("SUCCESS".equals(topUpOrderVO.getTradeState())) {
            // 远程调用用户钱包信息进行云享金增加操作
            ResultBody resultBody = userAppApi.feignTopUpCash(topUpOrderVO);
            if ("-1".equals(resultBody.getCode())) {
                log.error("===========用户支付成功，但由于远程调用失败，导致用户充值未到账，请手动处理该事件！param:{}=======>", topUpOrderVO);
            }
        }
        log.info("=========用户充值====>用户充值消费者消费结束。");
    }
}
