package com.mmc.oms.model.vo.order;

import com.mmc.oms.entity.order.OrderVcuDO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author small
 * @Date 2023/6/1 16:09
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.OrderRefundVO", description = "发货/收货类")
public class OrderRefundVO implements Serializable {
    private static final long serialVersionUID = 5392913587235842548L;
    @ApiModelProperty(value = "订单ID")
    @NotNull
    private Integer orderInfoId;
    @ApiModelProperty(value = "退款理由/原因")
    private String reason;
    @ApiModelProperty(value = "补充描述和凭证")
    private String remark;
    @ApiModelProperty(value = "图片集合")
    private List<String> imgs;
    @ApiModelProperty(value = "视频")
    private String videoUrl;

    public OrderVcuDO buildOrdeVcu() {
        return OrderVcuDO.builder().remark(this.remark)
                .imgs(CollectionUtils.isEmpty(this.imgs) ? null : String.join(",", this.imgs)).videoUrl(this.videoUrl)
                .orderInfoId(this.orderInfoId).build();
    }
}
