package com.mmc.oms.model.vo.mall;

import com.mmc.oms.common.publicinterface.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
@Data
@AllArgsConstructor
@NoArgsConstructor
/**
 * @author: zj
 * @Date: 2023/6/3 15:51
 */
public class ConfirmMallOrderVO implements Serializable {
    private static final long serialVersionUID = 517823200496391461L;
    @ApiModelProperty("购物车信息")
    @NotNull(message = "inspectionId不能为空", groups = { Query.class })
    private List<ConfirmShopVO> shopCarList;
    @ApiModelProperty("收货地址id")
    private Integer userAddressId;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "优惠券id")
    private List<Integer> couponIds;
}
