package com.mmc.oms.model.dto.order;

import com.mmc.oms.model.dto.repo.RepoCashDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author small @Date 2023/5/26 11:23 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.dto.OrderRefundDTO", description = "退款单DTO")
public class OrderRefundDTO implements Serializable {
    private static final long serialVersionUID = -6124933008580173589L;

    @ApiModelProperty(value = "退款单ID")
    private Integer id;

    @ApiModelProperty(value = "订单ID")
    private Integer orderInfoId;

    @ApiModelProperty(value = "退款单号")
    private String refundNo;

    @ApiModelProperty(value = "退款单状态：查字典")
    private Integer refundStatus;

    @ApiModelProperty(value = "应退款金额")
    private BigDecimal shouldRefund;

    @ApiModelProperty(value = "实际退款金额")
    private BigDecimal actualRefund;

    @ApiModelProperty(value = "退款理由")
    private String reason;

    @ApiModelProperty(value = "创建时间/申请时间")
    private Date createTime;

    @ApiModelProperty(value = "退款-设备情况(图片&视频)")
    private OrderVcuDTO orderVcu;

    @ApiModelProperty(value = "订单信息")
    private OrderInfoDTO orderInfo;

    @ApiModelProperty(value = "退款协商历史")
    private List<RefundLogDTO> rlogs;

    @ApiModelProperty(value = "退款流水信息")
    private RepoCashDTO refundCash;

    @ApiModelProperty(value = "平台备注")
    private String pfRemark;
}
