package com.mmc.oms.entity.goods;

import com.mmc.oms.model.dto.goods.AppGoodsInfoDTO;
import com.mmc.oms.model.dto.goods.GoodsInfoListDTO;
import com.mmc.oms.model.dto.goods.GoodsRcdDTO;
import com.mmc.oms.model.dto.goods.TypeGoodsInfoDTO;
import com.mmc.oms.model.vo.category.CategoryParamAndValueVO;
import com.mmc.oms.model.vo.goods.GoodsAddVO;
import com.mmc.oms.model.vo.goods.MallGoodsAddVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/24 15:14
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
public class GoodsInfoDO implements Serializable {
    private static final long serialVersionUID = -1329342381196659417L;
    private Integer id;
    private Integer pid;
    private String goodsNo;
    private String goodsName;
    private Integer masterTypeId;
    private Integer slaveTypeId;
    private Integer shelfStatus;
    private Integer skuNum;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;
    private Integer goodsAttr;
    private String ecoLabel;
    private Integer goodsCategoryId;
    private Integer repoId;
    private Integer shareFlyServiceId;
    private Integer goodsType;
    private Integer sort;
    private Integer showCode;
    private Integer standardProduct;
    private String tag;


    /**
     * 辅助字段-start
     */
    private String videoUrl;
    private Integer goodsVideoId;
    private String goodsDesc;
    // privateGoodsVideoDO goodsVideoDO;
    private String mainImg; // 主图
    //  private GoodsTypeDO goodsMasterType;
    // private GoodsTypeDO goodsSlaveType;
    private String remark;// 底部备注
    private Integer directoryId;
    private List<CategoryParamAndValueVO> paramAndValue;
    // private GoodsConfigExportDO goodsConfigExport;// 功能清单
    private Integer buyNum;// 购买数量
    private String directoryName;

    /**
     * 辅助字段-end
     */

    public GoodsInfoDO(MallGoodsAddVO mallGoodsAddVO) {
        this.id = mallGoodsAddVO.getGoodsInfoVO().getId();
        this.goodsName = mallGoodsAddVO.getGoodsInfoVO().getGoodsName();
        this.masterTypeId = mallGoodsAddVO.getGoodsInfoVO().getMasterTypeId();
        this.slaveTypeId = mallGoodsAddVO.getGoodsInfoVO().getSlaveTypeId();
        this.goodsAttr = mallGoodsAddVO.getGoodsInfoVO().getGoodsAttr();
        this.ecoLabel = mallGoodsAddVO.getGoodsInfoVO().getGoodsAttr() == 1 ? mallGoodsAddVO.getGoodsInfoVO().getEcoLabel() : null;
        this.repoId = mallGoodsAddVO.getGoodsInfoVO().getRepoId() == null ? null : mallGoodsAddVO.getGoodsInfoVO().getRepoId();
        this.shareFlyServiceId = mallGoodsAddVO.getGoodsInfoVO().getShareFlyServiceId() == null ? null : mallGoodsAddVO.getGoodsInfoVO().getShareFlyServiceId();
    }

    // 新版无人机城构造器
    public GoodsInfoDO(GoodsAddVO goodsAddVO) {
        this.id = goodsAddVO.getId();
        this.goodsName = goodsAddVO.getGoodsName();
        this.shelfStatus = goodsAddVO.getShelfStatus();
        this.masterTypeId = goodsAddVO.getMasterTypeId();
        this.slaveTypeId = goodsAddVO.getSlaveTypeId();
        this.directoryId = goodsAddVO.getDirectoryId();
        this.repoId = goodsAddVO.getRepoId();
        this.shareFlyServiceId = goodsAddVO.getShareFlyServiceId();
        this.tag = goodsAddVO.getTag();
    }

    public GoodsInfoListDTO buildGoodsInfoListDTO() {
        return GoodsInfoListDTO.builder().id(this.id)
                .goodsName(this.goodsName)
                .status(this.shelfStatus)
                .createTime(this.createTime)
                .imgUrl(this.mainImg)
                .directoryId(this.directoryId)
                .directoryName(this.directoryName)
                .build();
    }

    public AppGoodsInfoDTO buildAppGoodsInfoDTO() {
        return AppGoodsInfoDTO.builder()
                .id(this.id)
                .goodsName(this.goodsName)
                .mainImg(this.mainImg)
                .goodsDesc(this.goodsDesc)
                .shelfStatus(this.shelfStatus)
                .goodsAttr(this.goodsAttr)
                .ecoLabel(this.tag)
                .showCode(this.showCode)
                .sort(this.sort)
                .build();
    }

    public GoodsRcdDTO buildGoodsRcdDTO() {
        return GoodsRcdDTO.builder().id(this.id)
                .rcdGoodsName(this.goodsName)
                .rcdGoodsDescription(this.goodsDesc)
                .imgUrl(this.mainImg).build();
    }

    public TypeGoodsInfoDTO buildTypeGoodsInfoDTO() {
        return TypeGoodsInfoDTO.builder().goodsId(this.id)
                .goodsImg(this.mainImg).goodsName(this.goodsName)
                .showCode(this.showCode).shelfStatus(this.shelfStatus)
                .build();
    }

}
