package com.mmc.oms.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.mmc.oms.entity.coupon.CouponUsageDetailsDO;
import com.mmc.oms.entity.coupon.CouponUserDO;
import com.mmc.oms.entity.goods.GoodsInfoDO;
import com.mmc.oms.model.dto.coupon.CouponUserDTO;
import com.mmc.oms.model.qo.CouponUserInfoQO;
import com.mmc.oms.model.vo.coupon.CouponUserVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * @Author small
 * @Date 2023/5/24 15:09
 * @Version 1.0
 */
@Mapper
public interface CouponUserDao extends BaseMapper<CouponUserDO> {

    List<CouponUserDO> selectCouponUserList(String list, Integer uid, String data);

    List<CouponUserDTO> selectCouponUserInfoList(CouponUserInfoQO couponUserInfoQO);

    Integer selectCouponUserInfoCount(CouponUserInfoQO couponUserInfoQO);

    Integer insertCouponUserOrder(CouponUserVO couponUserVO);

    List<Long> getOrderList(Integer id);

    void batchRemoveByOIds(@Param("orderIds") Set<Long> orderIds);

    List<Integer> merchandise(Integer couponId);

    List<GoodsInfoDO> couponMerchandise(List<Integer> merchandise, String productName);

    List<CouponUsageDetailsDO> couponUsageDetails(Integer uid);

    List<GoodsInfoDO> VipCouponMerchandise(String productName);
}
