package com.mmc.oms.entity.order;

import com.mmc.oms.model.dto.order.OrderRefundDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small @Date 2023/5/26 17:13 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderRefundDO implements Serializable {
    private static final long serialVersionUID = 4323688698785079576L;
    private Integer id;
    private Integer orderInfoId;
    private String refundNo;
    private Integer refundStatus;
    private BigDecimal shouldRefund;
    private BigDecimal actualRefund;
    private String reason;
    private String pfRemark;
    private Date createTime;

    private OrderInfoDO orderInfo;
    private Integer userAccountId;

    public OrderRefundDTO buildOrderRefundDTO() {
        return OrderRefundDTO.builder()
                .id(this.id)
                .orderInfoId(this.orderInfoId)
                .refundStatus(this.refundStatus)
                .shouldRefund(this.shouldRefund)
                .actualRefund(this.actualRefund)
                .reason(this.reason)
                .refundNo(this.refundNo)
                .orderInfo(this.orderInfo == null ? null : this.orderInfo.buildOrderInfoDTO())
                .pfRemark(this.pfRemark)
                .createTime(this.createTime)
                .build();
    }
}
