package com.mmc.oms.model.vo.order;

import com.mmc.oms.common.publicinterface.Auto;
import com.mmc.oms.common.publicinterface.Send;
import com.mmc.oms.common.publicinterface.Take;
import com.mmc.oms.entity.order.OrderReceiptDO;
import com.mmc.oms.entity.order.OrderVcuDO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/31 15:41
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.OrderVcuVO", description = "发货/收货类")
public class OrderVcuVO implements Serializable {
    private static final long serialVersionUID = -4483344821357835193L;
    @ApiModelProperty(value = "订单ID")
    @NotNull(message = "订单id不能为空", groups = {Send.class, Auto.class})
    private Integer orderInfoId;
    @ApiModelProperty(value = "退款单id（退款-发货必填，其他可不填）")
    @NotNull(message = "退款单id不能为空", groups = {Auto.class})
    private Integer orderRefundId;
    @ApiModelProperty(value = "物流公司编码")
    @NotNull(message = "物流公司编码不能为空")
    private String sendExCode;
    @ApiModelProperty(value = "物流单号")
    @NotNull(message = "物流单号不能为空")
    private String sendExNo;
    @ApiModelProperty(value = "发货地址")
    private String sendAddress;
    @ApiModelProperty(value = "退换货-电话")
    @NotNull(message = "退换货-电话不能为空", groups = {Send.class})
    private String renPhone;
    @ApiModelProperty(value = "退换货-姓名")
    @NotNull(message = "退换货-姓名不能为空", groups = {Send.class})
    private String renName;
    @ApiModelProperty(value = "退换货-地址")
    @NotNull(message = "退换货-地址不能为空", groups = {Send.class})
    private String renAddress;
    @ApiModelProperty(value = "设备状况:0无问题 1有问题")
    @NotNull(message = "设备状况", groups = {Take.class})
    private Integer vcuSatus;
    @ApiModelProperty(value = "补充描述")
    private String remark;
    @ApiModelProperty(value = "图片集合")
    private List<String> imgs;
    @ApiModelProperty(value = "视频")
    private String videoUrl;
    @ApiModelProperty(value = "操作密码")
    private String authPwd;

    public OrderReceiptDO buildReceipt() {
        return OrderReceiptDO.builder().orderInfoId(this.orderInfoId).sendExCode(this.sendExCode)
                .sendExNo(this.sendExNo).sendAddress(this.sendAddress).renPhone(this.renPhone).renName(this.renName)
                .renAddress(this.renAddress).build();
    }

    public OrderVcuDO buildOrdeVcu() {
        return OrderVcuDO.builder().vcuSatus(this.vcuSatus).remark(this.remark)
                .imgs(CollectionUtils.isEmpty(this.imgs) ? null : String.join(",", this.imgs)).videoUrl(this.videoUrl)
                .orderInfoId(this.orderInfoId).build();
    }

}

