package com.mmc.oms.dao;

import com.mmc.oms.entity.order.*;
import com.mmc.oms.entity.transtatus.TranStatusDicDO;
import com.mmc.oms.model.qo.OrderInfoQO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/5/31 16:23
 * @Version 1.0
 */
@Mapper
public interface OrderLogisticsDao {

    OrderInfoDO getOrderInfo(Integer orderInfoId);

    void insertOrderInfo(OrderInfoDO order);

    List<TranStatusDicDO> listTranStatus();

    OrderInfoDO getOrderDetail(String orderNo);

    void insertOrderReceipt(OrderReceiptDO receipt);

    OrderReceiptDO getOrderReceiptByOrder(Integer orderInfoId);

    OrderInfoDO getAccountOrderInfo(Integer orderInfoId, Integer repoAccountId);

    void updateOrderInfo(OrderInfoDO orderInfo);

    void updateOrderReceipt(OrderReceiptDO receipt);

    OrderInfoDO getOrderSimpleInfo(Integer orderInfoId);

    int countPageOrderInfo(OrderInfoQO param);

    List<OrderInfoDO> listPageOrderInfo(OrderInfoQO param);

    List<KdnDicDO> listKdnDic();

    int countPcOrderInfo(OrderInfoQO param);

    List<OrderInfoDO> listPcOrderInfo(OrderInfoQO param);

    int countOrderInfo(String tranStatus, List<Integer> companys);

    List<ExpressInfoDO> listExpressInfo();

    void insertOrderVcu(OrderVcuDO vcu);

    OrderReceiptDO getOrderReceiptInfo(Integer orderInfoId);

    OrderVcuDO getOrderVcuInfo(Integer orderInfoId, Integer vcuType);

    OrderVcuDO getRefundVcuInfo(Integer orderRefundId, Integer vcuType);

    List<OrderVcuDO> listOrderVcuInfo(Integer orderInfoId);

    List<OrderInfoDO> listOrderByTranStatus(String tranStatus);

    Integer batchUpdateConfirmTake();

    int listPcOrderInfoCount();

    Integer getOrderInfoCountToYesterday(@Param("day") Integer day, @Param("date") Date date);

    Integer getOrderInfoCount(@Param("day") Integer day, @Param("date") Date date);
}
