package com.mmc.oms.feign;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.feign.hystrix.PaymentAppApiHystrix;
import com.mmc.oms.model.vo.ApplyRefundVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

/**
 * @author: zj
 * @Date: 2023/9/8 11:08
 */
@FeignClient(url = "${payment.url}", name = "payment-svc", fallback = PaymentAppApiHystrix.class)
public interface PaymentAppApi {

    @PostMapping("wechat/applyRefund")
    public ResultBody applyRefund(@RequestBody ApplyRefundVO applyRefundVO, @RequestHeader String token);
}
