package com.mmc.oms.model.qo.mall;

import com.mmc.oms.common.publicinterface.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/3 16:16
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MallOrderQO implements Serializable {
    private static final long serialVersionUID = 2731972353187680762L;
    @ApiModelProperty(value = "关键字-订单编号", required = false)
    private String keyword;

    @ApiModelProperty(value = "关键字-用户", required = false)
    private String keyword2;

    @ApiModelProperty(value = "状态码")
    private List<Integer> statusCode;

    @ApiModelProperty(value = "合同签署状态")
    private List<Integer> signStatus;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "订单对应的运营人员id", hidden = true)
    private Integer operationId;

    @ApiModelProperty(value = "销售id")
    private Integer saleId;

    @ApiModelProperty(value = "展示类型：0意向，1签约，2待发货，3待收货，4已完成，5已关闭")
    private Integer showType;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}