package com.mmc.oms.model.excel;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import com.mmc.oms.model.dto.mall.MallOrderPageDTO;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@NoArgsConstructor
@ExcelTarget("mallOrderExcel")
public class MallOrderExcel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Excel(name = "订单编号", orderNum = "1", width = 25)
    private String orderNo;

    @Excel(name = "订单名称", orderNum = "2", width = 25)
    private String goodsName;

    @Excel(name = "商品总数", orderNum = "3", width = 25)
    private Integer buyNums;

    @Excel(name = "状态", orderNum = "4", width = 25)
    private String statusName;

    @Excel(name = "运营人员", orderNum = "5", width = 25)
    private String operationName;

    @Excel(name = "订单交期", orderNum = "6", width = 25, databaseFormat = "yyyyMMdd", format = "yyyy-MM-dd", isImportField = "true_st", timezone = "Asia/Shanghai")
    private Date deliveryTime;

    @Excel(name = "合同编号", orderNum = "7", width = 25)
    private String contractNo;

    @Excel(name = "创建时间", orderNum = "5", width = 25, databaseFormat = "yyyyMMdd", format = "yyyy-MM-dd HH:mm:ss", isImportField = "true_st", timezone = "Asia/Shanghai")
    private Date createdTime;

    @Excel(name = "买家账号", orderNum = "6", width = 25)
    private String userName;

    @Excel(name = "推荐人", orderNum = "7", width = 25)
    private String recMallUserName;

    public MallOrderExcel(String orderNo, String goodsName, Integer buyNums, String statusName, String operationName, Date deliveryTime, String contractNo, Date createdTime, String userName, String recMallUserName) {
        this.orderNo = orderNo;
        this.goodsName = goodsName;
        this.buyNums = buyNums;
        this.statusName = statusName;
        this.operationName = operationName;
        this.deliveryTime = deliveryTime;
        this.contractNo = contractNo;
        this.createdTime = createdTime;
        this.userName = userName;
        this.recMallUserName = recMallUserName;
    }

    public MallOrderExcel(MallOrderPageDTO d) {
        this.orderNo = d.getOrderNo();
        this.goodsName = d.getOrderName();
        this.buyNums = d.getTotalBuyNum();
        this.operationName = d.getOperationName();
        this.deliveryTime = d.getDeliveryTime();
        this.contractNo = d.getContractNo();
        this.createdTime = d.getCreateTime();
        this.userName = d.getUserName();
        this.recMallUserName = d.getRecMallUserName();
    }
}
