package com.mmc.oms.controller.demand;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.oms.common.publicinterface.Insert;
import com.mmc.oms.common.publicinterface.Update;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.controller.demand.commit.NotRepeatSubmit;
import com.mmc.oms.model.vo.demand.CommonPaymentVO;
import com.mmc.oms.model.vo.demand.DemandReleaseOrderVO;
import com.mmc.oms.service.demand.DemandReleaseOrderService;
import io.swagger.annotations.*;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/7/25 15:04
 * @Version 1.0
 */
@Api(tags = {"需求发布订单"})
@RestController
@RequestMapping("/releaseOrder")
public class DemandReleaseOrderController extends BaseController {
    @Autowired
    private DemandReleaseOrderService releaseOrderService;


    @ApiIgnore
    @ApiOperation(value = "小程序——需求发布订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/publish")
    public ResultBody publish(@RequestBody @Validated(value = {Insert.class}) DemandReleaseOrderVO demandReleaseOrderVO, HttpServletRequest request) {
        demandReleaseOrderVO.setUserAccountId(this.getCurrentAccount(request).getUserAccountId());
        return releaseOrderService.publish(demandReleaseOrderVO, request);
    }


    @ApiOperation(value = "订单支付")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/orderPayment")
    @NotRepeatSubmit(value = 3000L)
    public ResultBody orderPayment(@RequestBody @Validated CommonPaymentVO commonPaymentVO, HttpServletRequest request) {
        return releaseOrderService.orderPayment(commonPaymentVO, request,this.getCurrentAccount(request).getUserAccountId());
    }


    @ApiOperation(value = "获取发布者的电话")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/getPublishPhone")
    public ResultBody getPublishPhone(@RequestBody @Validated CommonPaymentVO commonPaymentVO, HttpServletRequest request) {
        return releaseOrderService.getPublishPhone(commonPaymentVO, request,this.getCurrentAccount(request).getUserAccountId());
    }


     @ApiOperation(value = "通过id删除订单")
     @GetMapping("/getDeleteOrder")
    public ResultBody getDelete(@ApiParam(value = "requirementsInfoId", required = true) @RequestParam Integer requirementsInfoId ){
        return releaseOrderService.getDelete(requirementsInfoId);
    }

    @ApiOperation(value = "通过需求id获取支付编号")
    @GetMapping("/getPaymentOrderNumber")
    public String getOrderNumber(@ApiParam(value = "requirementsInfoId", required = true) @RequestParam Integer requirementsInfoId){
      return  releaseOrderService.getOrderNumber(requirementsInfoId);
    }














}
