package com.mmc.oms.service.Impl;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.dao.UserAddressDao;
import com.mmc.oms.entity.mall.UserAddressDO;
import com.mmc.oms.feign.PmsAppApi;
import com.mmc.oms.model.dto.mall.UserAddressDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.qo.mall.UserAddressQO;
import com.mmc.oms.model.vo.mall.UserAddressVO;
import com.mmc.oms.service.UserAddressService;
import com.mmc.oms.util.BeanCopyUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/6/7 10:15
 */
@Service
@Slf4j
public class UserAddressServiceImpl implements UserAddressService {
    @Autowired
    private UserAddressDao userAddressDao;
    @Autowired
    private PmsAppApi pmsAppApi;
    @Override
    public ResultBody insert(UserAddressVO param, BaseAccountDTO currentAccount) {
        // 如果之前有默认的话，就要修改为非默认
        isDefault(param, currentAccount);
        UserAddressDO userAddressDO = BeanCopyUtils.properties(param, new UserAddressDO());
        userAddressDO.setUserAccountId(currentAccount.getUserAccountId());
        userAddressDO.setFlag(currentAccount.getPortType());
        userAddressDao.insert(userAddressDO);
        return ResultBody.success();
    }

    private void isDefault(UserAddressVO param, BaseAccountDTO currentAccount) {
        if(param.getType()!=null && param.getType().equals(0)){
            userAddressDao.update(new UserAddressDO(currentAccount.getUserAccountId(),1,currentAccount.getPortType()));
        }
    }

    @Override
    public ResultBody update(UserAddressVO param, BaseAccountDTO currentAccount) {
        isDefault(param,currentAccount);
        userAddressDao.removeById(param.getId());
        UserAddressDO userAddressDO = BeanCopyUtils.properties(param, new UserAddressDO());
        userAddressDO.setFlag(currentAccount.getPortType());
        userAddressDO.setUserAccountId(currentAccount.getUserAccountId());
        userAddressDao.insert(userAddressDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deleteById(Integer id) {
        ResultBody resultBody = pmsAppApi.feignLeaseGoodsInfoByAddressId(id);
        if (resultBody == null || !resultBody.getCode().equals("200")) {
            log.error("远程调用失败：返回数据为null=====>UserAddressServiceImpl.deleteById=====>param{}",id);
            return ResultBody.error("服务器异常，请稍后重试！");
        }
        int count = (int)resultBody.getResult();
        if (count > 0) {
            return ResultBody.error("有商品绑定该地址，不可删除！");
        }
        userAddressDao.removeById(id);
        return ResultBody.success();
    }

    @Override
    public UserAddressDTO getUserAddressInfo(Integer userAddressId) {
        UserAddressDO userAddressDO = userAddressDao.selectById(userAddressId);
        UserAddressDTO userAddressDTO = BeanCopyUtils.properties(userAddressDO, new UserAddressDTO());
        return userAddressDTO;
    }

    @Override
    public ResultBody<List<UserAddressDTO>> selectList(UserAddressQO param, BaseAccountDTO currentAccount) {
        param.setUserAccountId(currentAccount.getUserAccountId());
        param.setFlag(currentAccount.getPortType());
        UserAddressDO userAddressDO = BeanCopyUtils.properties(param, new UserAddressDO());
        List<UserAddressDO> list = userAddressDao.selectList(userAddressDO);
        List<UserAddressDTO> collect = list.stream().map(item -> BeanCopyUtils.properties(item, new UserAddressDTO())).collect(Collectors.toList());
        return ResultBody.success(collect);
    }
}
