package com.mmc.oms.model.vo.lease;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2023/9/23 15:36
 * 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LeaseOrderRefundVO implements Serializable {
    @ApiModelProperty("id")
    private Integer id;
    @ApiModelProperty("订单id")
    private Integer orderId;
    @ApiModelProperty("归还状态 0已归还 1无需归还(注：发货后申请退款需要传，归还商品的时候不需要)")
    private Integer status;
    @ApiModelProperty("商家确认商品是否破损 0:未破损 1:破损")
    private Integer damage;
    @ApiModelProperty("物流单号")
    private String expressNum;
    @ApiModelProperty(value = "物流编码")
    private String expressCode;
    @ApiModelProperty("图片文件")
    private String file;
    @ApiModelProperty("原因")
    private String reason;
    @ApiModelProperty("扣除的押金")
    private BigDecimal deductionAmount;
}
