package com.mmc.oms.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/6/8 20:53
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.mall.dto.MallUserDTO", description = "用户信息DTO")
public class OrderExpressDTO implements Serializable {
    private static final long serialVersionUID = 5884071559569250219L;
    @ApiModelProperty(value = "orderId")
    private Long orderId;
    @ApiModelProperty(value = "发货-快递公司编码")
    private String sendExpNo;
    @ApiModelProperty(value = "发货-快递单号")
    private String sendExpCode;
    @ApiModelProperty(value = "发货-收货人名字")
    private String takeName;
    @ApiModelProperty(value = "发货-收货人手机号")
    private String takePhone;
    @ApiModelProperty(value = "发货-收货地区")
    private String takeRegion;
    @ApiModelProperty(value = "发货-收货详细地址")
    private String takeAddress;

    private Integer orderInfoId;
    private String sendExCode;
    private String sendExNo;
    private String region;
    private String detailAddress;

    private Integer renMethod;
    private String renPhone;
    private String renName;
    private String renExCode;
    private String renExNo;
    private String renAddress;
    private String renRepoName;
    private String renRepoAddr;
    private String renRepoPhone;


    public OrderExpressDTO buildOrderExpressDTO() {
        return OrderExpressDTO.builder().orderInfoId(orderInfoId).sendExNo(sendExNo).sendExCode(sendExCode)
                .takeName(takeName).takePhone(takePhone).region(region).detailAddress(detailAddress).build();
    }
}
