package com.mmc.oms.service.Impl;

import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.dao.UserAddressDao;
import com.mmc.oms.entity.mall.UserAddressDO;
import com.mmc.oms.model.dto.mall.UserAddressDTO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.qo.mall.UserAddressQO;
import com.mmc.oms.model.vo.mall.UserAddressVO;
import com.mmc.oms.service.UserAddressService;
import com.mmc.oms.util.BeanCopyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/6/7 10:15
 */
@Service
public class UserAddressServiceImpl implements UserAddressService {
    @Autowired
    private UserAddressDao userAddressDao;

    @Override
    public ResultBody insert(UserAddressVO param, BaseAccountDTO currentAccount) {
        // 如果之前有默认的话，就要修改为非默认
        isDefault(param, currentAccount.getUserAccountId());
        UserAddressDO userAddressDO = BeanCopyUtils.properties(param, new UserAddressDO());
        userAddressDO.setUserAccountId(currentAccount.getUserAccountId());
        userAddressDao.insert(userAddressDO);
        return ResultBody.success();
    }

    private void isDefault(UserAddressVO param, Integer userAccountId) {
        if(param.getType()!=null && param.getType().equals(0)){
            userAddressDao.update(new UserAddressDO(userAccountId,1));
        }
    }

    @Override
    public ResultBody update(UserAddressVO param, BaseAccountDTO currentAccount) {
        isDefault(param,currentAccount.getUserAccountId());
        userAddressDao.removeById(param.getId());
        userAddressDao.insert(BeanCopyUtils.properties(param, new UserAddressDO()));
        return ResultBody.success();
    }

    @Override
    public ResultBody deleteById(Integer id) {
        userAddressDao.removeById(id);
        return ResultBody.success();
    }

    @Override
    public UserAddressDTO getUserAddressInfo(Integer userAddressId) {
        UserAddressDO userAddressDO = userAddressDao.selectById(userAddressId);
        UserAddressDTO userAddressDTO = BeanCopyUtils.properties(userAddressDO, new UserAddressDTO());
        return userAddressDTO;
    }

    @Override
    public ResultBody<List<UserAddressDTO>> selectList(UserAddressQO param, BaseAccountDTO currentAccount) {
        param.setUserAccountId(currentAccount.getUserAccountId());
        UserAddressDO userAddressDO = BeanCopyUtils.properties(param, new UserAddressDO());
        List<UserAddressDO> list = userAddressDao.selectList(userAddressDO);
        List<UserAddressDTO> collect = list.stream().map(item -> BeanCopyUtils.properties(item, new UserAddressDTO())).collect(Collectors.toList());
        return ResultBody.success(collect);
    }
}
