package com.mmc.oms.service.Impl;

import com.mmc.oms.common.ResultEnum;
import com.mmc.oms.common.VcuType;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.common.status.RefundStatus;
import com.mmc.oms.common.status.TranStatusDic;
import com.mmc.oms.common.util.CodeUtil;
import com.mmc.oms.dao.OrderRefundDao;
import com.mmc.oms.dao.RentalOrdersDao;
import com.mmc.oms.entity.order.OrderInfoDO;
import com.mmc.oms.entity.order.OrderRefundDO;
import com.mmc.oms.entity.order.OrderVcuDO;
import com.mmc.oms.model.dto.user.BaseAccountDTO;
import com.mmc.oms.model.vo.order.OrderRefundVO;
import com.mmc.oms.model.vo.order.RefundYesOrNoVO;
import com.mmc.oms.service.OrderRefundService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/6/1 16:03
 * @Version 1.0
 */
@Service
public class OrderRefundServiceImpl implements OrderRefundService {

    @Autowired
    private OrderRefundDao orderRefundDao;

    @Autowired
    private RentalOrdersDao rentalOrdersDao;

    @Value("${payment.url}")
    private String paymentUrl;

    @Autowired
    private RestTemplate restTemplate;

    @Override
    @Transactional
    public ResultBody applyRetreat(BaseAccountDTO account, OrderRefundVO param) {
        OrderInfoDO order = rentalOrdersDao.getOrderInfo(param.getOrderInfoId());
        if (!TranStatusDic.YFK.getStatus().equals(order.getTranStatus())) {
            return ResultBody.error(ResultEnum.ORDER_STATUS_ERROR);
        }

        int count = orderRefundDao.countValidRefund(param.getOrderInfoId());
        if (count > 0) {
            return ResultBody.error(ResultEnum.ORDER_REFUND_EXIT_ERROR);
        }

        Date cdate = new Date();
        // 添加申请单
        OrderRefundDO refund = new OrderRefundDO();
        refund.setOrderInfoId(order.getId());
        refund.setRefundNo(CodeUtil.createOrderRefund());
        refund.setRefundStatus(RefundStatus.INIT.getCode());
        refund.setShouldRefund(order.getActualPay());
        refund.setActualRefund(BigDecimal.ZERO);
        refund.setReason(param.getReason());
        refund.setCreateTime(cdate);
        refund.setUserAccountId(account.getUserAccountId());
        orderRefundDao.insertOrderRefund(refund);

        // 订单-视频、图片
        OrderVcuDO vcu = param.buildOrdeVcu();
        vcu.setOrderRefundId(refund.getId());
        vcu.setVcuType(VcuType.RETREAT.getCode());
        vcu.setCreateTime(cdate);
        orderRefundDao.insertOrderVcu(vcu);

        // 申请进度log
      /*  RefundLogDO rlog = new RefundLogDO();
        rlog.setOrderRefundId(refund.getId());
        rlog.setRefundCode(RefundShd.INIT.getStatus());
        String msg = "发起退款申请，货物状态：未发货，原因：" + param.getReason() + "，金额：" + order.getActualPay() + "元";
        rlog.setMsg(msg);
        rlog.setOpAccount(account.getUid());
        rlog.setOpName(account.getAccountName());
        rlog.setCreateTime(cdate);
        orderRefundDao.insertRefundLog(rlog);*/

        // 修改订单状态
        OrderInfoDO upOrder = new OrderInfoDO();
        upOrder.setId(param.getOrderInfoId());
        upOrder.setTranStatus(TranStatusDic.TKSQ.getStatus());
        rentalOrdersDao.updateOrderInfo(upOrder);
        return ResultBody.success();
    }

    @Override
    public ResultBody refund(BaseAccountDTO currentAccount, RefundYesOrNoVO param) {
        if (currentAccount.getPortType() != 0) {
            return ResultBody.error(ResultEnum.NO_PERMISSION_TEMPORARILY);
        }
        OrderInfoDO order = rentalOrdersDao.getOrderInfo(param.getOrderInfoId());
        OrderRefundDO applicationInformation = rentalOrdersDao.getApplicationInformation(order.getId());
        //同意退款就订单关闭
        //驳回订单还处于当前状态
        Boolean refund = param.getRefund();
        //同意退款
        if (refund.equals(true)) {
            rentalOrdersDao.updateOrder(order.getOrderNo(), RefundStatus.CLOSE.getCode());
            refundChanges(currentAccount.getToken(), order.getActualPay(), order.getOrderNo(), applicationInformation.getUserAccountId(), applicationInformation.getRefundNo());
            return ResultBody.success(RefundStatus.FINISH.getStatus());
        }
        rentalOrdersDao.updateOrder(order.getOrderNo(), RefundStatus.INIT.getCode());
        return ResultBody.error(ResultEnum.REFUND_FAILED);
    }

    /**
     * 退款金额变更
     *
     * @param orderNo
     * @return
     */
    private void refundChanges(String token, BigDecimal actualPay, String orderNo, Integer userAccountId, String refundNo) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        HttpEntity<MultiValueMap<String, Object>> formEntity = new HttpEntity<MultiValueMap<String, Object>>(headers);
        ResponseEntity<String> exchange = restTemplate.exchange(paymentUrl + "repocash/amountOfRefund?actualPay=" + actualPay
                        + "&orderNo=" + orderNo
                        + "&repoAccountId=" + userAccountId
                        + "&refundNo=" + refundNo,
                HttpMethod.GET, formEntity, String.class);
        System.out.println(exchange);

    }


}
