package com.mmc.oms.model.vo.mall;

import com.mmc.oms.common.publicinterface.Insert;
import com.mmc.oms.common.publicinterface.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 用户地址表
 * </p>
 *
 * @author dahang
 * @since 2022-08-31
 */
@Data
@ApiModel(value="UserAddressVO", description="用户地址表")
@AllArgsConstructor
@NoArgsConstructor
public class UserAddressVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "唯一标识")
    @NotNull(message = "id不能为空",groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;

    @ApiModelProperty(value = "收货人姓名")
    @Length(min = 1,max = 64,message = "收货人姓名不合法",groups = {Insert.class})
    private String takeName;

    @ApiModelProperty(value = "收货人电话")
    private String takePhone;

    @ApiModelProperty(value = "收货地址")
    @Length(max =250,message = "收货地址过长",groups = {Insert.class})
    private String takeRegion;

    @ApiModelProperty(value = "收货详细地址")
    @Length(max =250,message = "收货详细地址过长",groups = {Insert.class})
    private String takeAddress;

    @ApiModelProperty(value = "使用类型;0默认，1普通")
    @NotNull(message = "类型不能为空",groups = {Insert.class})
    private Integer type;
}
