package com.mmc.oms.model.vo.goods;

import com.mmc.oms.common.publicinterface.Create;
import com.mmc.oms.common.publicinterface.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/24 15:27
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.GoodsDetailVO", description = "商品详情")
public class GoodsDetailVO implements Serializable {
    private static final long serialVersionUID = -3842207843504795301L;
    @ApiModelProperty(value = "商品描述 ：70字内")
    @Size(max = 250, message = "商品描述不能超过250个字符", groups = {Create.class, Update.class})
    private String goodsDesc;
    @ApiModelProperty(value = "产品介绍")
    private String productDesc;
    @ApiModelProperty(value = "商品备注：100字以内")
    @Size(max = 100, message = "商品备注不能超过100个字符", groups = {Create.class, Update.class})
    private String remark;
}
