package com.mmc.oms.model.dto.service;


import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author LW
 * @date 2023/6/8 10:33
 * 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ServiceDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    @ApiModelProperty(value = "服务名称")
    private String serviceName;

    @ApiModelProperty(value = "应用")
    private Integer applicationId;

    @ApiModelProperty(value = "应用名称")
    private String applicationName;

    @ApiModelProperty(value = "行业")
    private Integer industryId;

    @ApiModelProperty(value = "行业名称")
    private String industryName;

    @ApiModelProperty(value = "展示状态")
    private Integer displayState;

    @ApiModelProperty(value = "封面图")
    private String coverPlan;

    @ApiModelProperty(value = "分享卡片")
    private String shareCard;

    @ApiModelProperty(value = "视频")
    private String video;

    @ApiModelProperty(value = "服务介绍")
    private String serviceIntroduction;

    @ApiModelProperty(value = "账号id")
    private Integer accountId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

}
