package com.mmc.oms.model.dto.flyer;

import com.mmc.oms.common.FlyerAccountType;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @Author small
 * @Date 2023/5/24 14:59
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.dto.FlyerAccountDTO", description = "飞手端用户DTO")
public class FlyerAccountDTO implements Serializable {
    private static final long serialVersionUID = -5663270547201316327L;
    @ApiModelProperty(value = "飞手端用户id")
    private Integer id;
    @ApiModelProperty(value = "飞手端用户uid")
    private String uid;
    @ApiModelProperty(value = "飞手端用户名称")
    private String accountName;
    @ApiModelProperty(value = "联系电话")
    private String phoneNum;
    @ApiModelProperty(value = "飞手端用户类型，（个人飞手，机构）")
    private Integer accountType;
    @ApiModelProperty(value = "实名认证状态")
    private Integer realAuthStatus;
    @ApiModelProperty(value = "企业认证状态")
    private Integer entAuthStatus;
    @ApiModelProperty(value = "工作状态")
    private Integer workStatus;
    @ApiModelProperty(value = "常驻城市")
    private String resAddress;
    @ApiModelProperty(value = "openId")
    private String openId;
    @ApiModelProperty(value = "unionId")
    private String unionId;
    @ApiModelProperty(value = "昵称")
    private String nickName;
    @ApiModelProperty(value = "头像url")
    private String headerImg;
    @ApiModelProperty(value = "经度")
    private Double lon;
    @ApiModelProperty(value = "纬度")
    private Double lat;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "删除状态，0未删除，1删除")
    private Integer deleted;
    @ApiModelProperty(value = "企业名称")
    private String entName;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "有无订单：0无,1有")
    private Integer serviceStatus;

    @ApiModelProperty(value = "距离订单距离-单位km")
    private Double orderDist;

    @ApiModelProperty(value = "服务中的订单名称")
    private List<String> orderNames;

    @ApiModelProperty(value = "飞手认证状态")
    private Integer licStatus;

    @ApiModelProperty(value = "机构信息")
    private FlyerEntInfoDTO entInfo;

    @ApiModelProperty(value = "抢单状态-0否-1是")
    private Integer applyOrder;

    @ApiModelProperty(value = "多端用户，USER_PORT(云享飞)-FLYER_PORT(云飞手)-REPO_PORT(云仓)")
    private Set<String> ports;

    @ApiModelProperty(value = "推荐人ID")
    private Integer rcdFlyerAccountId;

    @ApiModelProperty(value = "推荐人昵称")
    private String rcdNickName;

    @ApiModelProperty(value = "推荐人uid")
    private String rcdUid;

    @ApiModelProperty(value = "推荐人账号名称")
    private String rcdAccountName;

    @ApiModelProperty(value = "已推荐用户数")
    private Integer rcdUserNumber;

    @ApiModelProperty(value = "是否销售")
    private Integer sale;

    @ApiModelProperty(value = "是否白名单")
    private Integer white;

    @ApiModelProperty(value = "用户来源：0自然流，1海报，2抖音，3公众号，4社群，5招投标，默认0")
    private Integer source;

    @ApiModelProperty(value = "订单信息")
    private FlyerOrderTaskDTO flyerOrderTask;

    @ApiModelProperty(value = "场景认证信息")
    private FlyerScenesAuthDTO flyerScenesAuth;

    /**
     * 是否为飞手机构用户
     *
     * @return
     */
    public boolean checkFlyerEnt() {
        return (FlyerAccountType.JG.getCode().toString().equals(this.accountType.toString()));
    }

    /**
     * 是否为飞手个人用户
     *
     * @return
     */
    public boolean checkFlyer() {
        return (FlyerAccountType.GR.getCode().toString().equals(this.accountType.toString()));
    }

}
