package com.mmc.oms.entity.mall;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 云享飞服务订单-主表
 * </p>
 *
 * @author Pika
 * @since 2023-06-10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@TableName(value = "service_order_task")
public class ServiceOrderTaskDO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "唯一标识")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "订单名称")
    private String orderName;

    @ApiModelProperty(value = "订单总金额")
    private BigDecimal orderAmt;

    @ApiModelProperty(value = "订单状态,目前有用户端，飞手端，平台端")
    private Integer orderStatus;

    @ApiModelProperty(value = "客户ID")
    private Integer userAccountId;

    @ApiModelProperty(value = "运营人员ID（负责这个order的运营人员id)")
    private Integer userOperateId;

    @ApiModelProperty(value = "飞手ID")
    private Integer flyerId;

    @ApiModelProperty(value = "服务项ID")
    private Integer inspectionId;

    @ApiModelProperty(value = "服务名称")
    private String inspectionName;

    @ApiModelProperty(value = "预计服务开始时间")
    private Date startTime;

    @ApiModelProperty(value = "预计服务结束时间")
    private Date endTime;

    @ApiModelProperty(value = "实际服务开始时间")
    private Date acStartTime;

    @ApiModelProperty(value = "实际服务结束时间")
    private Date acEndTime;

    @ApiModelProperty(value = "任务描述")
    private String taskDescription;

    @ApiModelProperty(value = "平台备注")
    private String pfRemark;

    @ApiModelProperty(value = "是否显示：0 隐藏，1 显示")
    private Integer display;

    @ApiModelProperty(value = "创建时间")
    private Date createdTime;

    @ApiModelProperty(value = "更新时间")
    private Date updatedTime;

    @ApiModelProperty(value = "逻辑删除;1代表删除，0代表未删除")
    @TableLogic
    private Integer isDeleted;
}
