package com.mmc.oms.entity.mall;

import com.mmc.oms.model.dto.mall.GoodsServiceDTO;
import com.mmc.oms.model.dto.mall.OrderServiceDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/** 
* @author 作者 geDuo
* @version 创建时间：2022年3月24日 下午2:01:24 
* @explain 类说明 
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderServiceDO implements Serializable {
	private static final long serialVersionUID = -2938941346648852627L;
	private Integer id;
	private Integer orderId;
	private Integer goodsInfoId;
	private String serviceName;
	private String remark;
	private Date createTime;

	public OrderServiceDO(GoodsServiceDTO d, Integer orderId) {
		this.orderId = orderId;
		this.goodsInfoId = d.getGoodsInfoId();
		this.serviceName = d.getServiceName();
		this.remark = d.getRemark();
	}

	public OrderServiceDTO buildOrderServiceDTO() {
		return OrderServiceDTO.builder().goodsInfoId(goodsInfoId).orderId(orderId).serviceName(serviceName)
				.remark(remark).build();
	}
}
