package com.mmc.oms.entity.lease;

import com.mmc.oms.model.vo.lease.LeaseOrderRefundVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * (LeaseRefundOrderDO)实体类
 *
 * @author makejava
 * @since 2023-09-23 15:49:05
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LeaseRefundOrderDO implements Serializable {
    private static final long serialVersionUID = -78279245843440398L;

    private Integer id;

    private Integer leaseOrderId;
    /**
     * 归还状态：0已归还 1无需归还
     */
    private Integer status;
    /**
     * 物流单号
     */
    private String expressNum;
    /**
     * 图片文件
     */
    private String file;
    /**
     * 原因
     */
    private String reason;

    private Date createTime;

    private Date updateTime;

    public LeaseRefundOrderDO(LeaseOrderRefundVO leaseOrderRefundVO) {
        this.leaseOrderId = leaseOrderRefundVO.getId();
        this.status = leaseOrderRefundVO.getStatus();
        this.expressNum = leaseOrderRefundVO.getExpressNum();
        this.file = leaseOrderRefundVO.getFile();
        this.reason = leaseOrderRefundVO.getReason();
    }
}

