package com.mmc.oms.model.vo.demand;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/7/25 17:39
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class OrderRequestParamsVO implements Serializable {
    @ApiModelProperty(value = "订单编号")
    private String orderNo;
    @ApiModelProperty(value = "商品描述")
    private String description;
    @ApiModelProperty(value = "订单金额（分为单位）")
    private Integer amount;
    @ApiModelProperty(value = "订单来源 0：产品商城 1：租赁订单 2：培训订单 ...其他后续加")
    private Integer orderPort;
}
