package com.mmc.oms.model.qo.mall;

import com.mmc.oms.common.publicinterface.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 用户地址表
 * </p>
 *
 * @author dahang
 * @since 2022-08-31
 */
@Data
@ApiModel(value="UserAddressVO", description="用户地址表")
@AllArgsConstructor
@NoArgsConstructor
public class UserAddressQO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "唯一标识")
    @NotNull(message = "id不能为空",groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;

    @ApiModelProperty(value = "收货人姓名")
    private String takeName;

    @ApiModelProperty(value = "收货人电话")
    private String takePhone;

    @ApiModelProperty(value = "收货地址")
    private String takeRegion;

    @ApiModelProperty(value = "收货详细地址")
    private String takeAddress;

    @ApiModelProperty(value = "使用类型;0默认，1普通")
    private Integer type;

    @ApiModelProperty(value = "逻辑删除")
    private Integer isDeleted;

    @ApiModelProperty(value = "逻辑删除")
    private List<Integer> isDeleteds;

    @ApiModelProperty(value = "标识;0：PC，100:小程序",hidden = true)
    private Integer flag;
}
