package com.mmc.oms.model.dto.ware;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author small @Date 2023/5/26 13:20 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AppletWareInfoDTO implements Serializable {
    private static final long serialVersionUID = -8861604532607064616L;

    @ApiModelProperty(value = "ID")
    private Integer id;

    @ApiModelProperty(value = "商品编号")
    private String wareNo;

    @ApiModelProperty(value = "商品名称")
    private String wareName;

    @ApiModelProperty(value = "商品标题")
    private String wareTitle;

    @ApiModelProperty(value = "商品类型ID")
    private Integer wareTypeId;

    @ApiModelProperty(value = "商品状态")
    private Integer wareStatus;

    @ApiModelProperty(value = "减库方式")
    private Integer payStatus;

    @ApiModelProperty(value = "最小押金")
    private BigDecimal minDeposit;

    @ApiModelProperty(value = "最小租金")
    private BigDecimal minRent;

    @ApiModelProperty(value = "总库存数量")
    private Integer totalStock;

    @ApiModelProperty(value = "总销量")
    private Integer totalSale;

    @ApiModelProperty(value = "sku数量")
    private Integer skuNum;

    @ApiModelProperty(value = "标签集合")
    private List<String> tags;

    @ApiModelProperty(value = "商品图片集合")
    private List<WareImgDTO> wareImgs;

    @ApiModelProperty(value = "商品视频集合")
    private List<WareVideoDTO> wareVideos;
}
