package com.mmc.oms.entity.demand;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/19 16:59
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class GetOrderNumberDTO implements Serializable {

    private static final long serialVersionUID = 75097833899496576L;
    @ApiModelProperty(value = "制度订单编号", example = "dadasdas")
    private String paymentOrderNumber;

    @ApiModelProperty(value = "微信需要支付金额", example = "100")
    private BigDecimal weChatPay;

    @ApiModelProperty(value = "用户id", example = "100", hidden = true)
    private Integer userAccountId;


}
