package com.mmc.oms.controller.mall;

import com.mmc.oms.common.publicinterface.Query;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.controller.BaseController;
import com.mmc.oms.model.dto.mall.MallGoodsShopCarDTO;
import com.mmc.oms.model.vo.mall.ConfirmMallOrderVO;
import com.mmc.oms.model.vo.mall.MallShopCarVO;
import com.mmc.oms.service.mall.ShoppingTrolleyService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * author:zhenjie
 * Date:2022/10/11
 * time:10:21
 */
//@Api(tags = { "小程序-购物车-接口(改版后)" })
@RestController
@RequestMapping("/shopping-trolley/")
public class ShoppingTrolleyController extends BaseController {
    @Autowired
    private ShoppingTrolleyService shoppingTrolleyService;

    @ApiOperation(value = "加入购物车", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("addGoods")
    public ResultBody addGoods(@RequestBody MallShopCarVO mallShopCarVO, HttpServletRequest request){
        return shoppingTrolleyService.addGoods(mallShopCarVO, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "移除购物车", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("batchRemove/{type}")
    public ResultBody batchRemove(@RequestBody List<Integer> carIds, @PathVariable Integer type, HttpServletRequest request) {
        return shoppingTrolleyService.batchRemove(type, carIds, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "购物车列表", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = MallGoodsShopCarDTO.class) })
    @GetMapping("listPage")
    public ResultBody listPage(@RequestParam Integer pageNo, @RequestParam Integer pageSize,
                               HttpServletRequest request) {
        return shoppingTrolleyService.listPage(pageNo, pageSize, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "修改数量", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("updateBuyNum")
    public ResultBody updateBuyNum(@RequestParam(required = true) Integer directoryId, @RequestParam(required = true) Integer mallShopCarId,
                                   @ApiParam("改变的数量（正加负减）") @RequestParam(required = true) Integer buyNum, HttpServletRequest request) {
        return shoppingTrolleyService.updateBuyNum(directoryId, mallShopCarId, buyNum, this.getCurrentAccount(request));
    }

    @ApiOperation(value = "购物车-提交订单-批量获取商品信息", hidden = true)
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("confirmOrder")
    public ResultBody confirmOrder(@Validated(Query.class) @RequestBody ConfirmMallOrderVO param, HttpServletRequest request) {
        return shoppingTrolleyService.confirmShop(param, this.getCurrentAccount(request));
    }

//    @ApiOperation(value = "购物车导出")
//    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
//    @PostMapping("listShoppingTrolleyExport")
//    public ResultBody listShoppingTrolleyExport(@Validated(Query.class) @RequestBody List<ConfirmShopVO> shopCarList, HttpServletRequest request, HttpServletResponse response) throws IOException {
//        return shoppingTrolleyService.listShoppingTrolleyExport(shopCarList, this.getCurrentAccount(request), response);
//    }

}
