package com.mmc.oms.service.mall.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.mmc.oms.dao.mall.ServiceOrderStatusInfoDao;
import com.mmc.oms.entity.mall.ServiceOrderStatusInfoDO;
import com.mmc.oms.model.dto.mall.ServiceOrderStatusInfoDTO;
import com.mmc.oms.service.mall.ServiceOrderStatusInfoService;
import com.mmc.oms.util.BeanCopyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务订单状态 服务实现类
 * </p>
 *
 * @author Pika
 * @since 2023-06-11
 */
@Service
public class ServiceOrderStatusInfoServiceImpl extends ServiceImpl<ServiceOrderStatusInfoDao, ServiceOrderStatusInfoDO> implements ServiceOrderStatusInfoService {

    @Override
    public List<ServiceOrderStatusInfoDTO> getServiceOrderStatus() {
        List<ServiceOrderStatusInfoDO> statusInfoDOS = this.list();
        if (CollectionUtils.isEmpty(statusInfoDOS)){
            return Lists.newArrayList();
        }
        return statusInfoDOS.stream().map(d->BeanCopyUtils.properties(d,new ServiceOrderStatusInfoDTO())).collect(Collectors.toList());
    }
}
