package com.mmc.oms.schedule;

import com.mmc.oms.service.uav.UavOrderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @author: zj
 * @Date: 2023/9/9 17:34
 */
@Slf4j
@Component
public class ScheduleController {

    @Autowired
    private UavOrderService uavOrderService;

    @Scheduled(fixedDelay = 5 * 60 * 1000)
    public void checkNoReceiveUavOrder() {
        log.info("checkNoReceiveUavOrder");
        uavOrderService.checkNoReceive();
    }
}
