package com.mmc.oms.model.vo.mall;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

import java.io.Serializable;
import java.util.Set;

/**
 * @author: zj
 * @Date: 2023/6/8 14:01
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class MallConfirmOrderVO implements Serializable {
    private static final long serialVersionUID = 8599190969887960567L;
    @ApiModelProperty(value = "商品id")
    private Integer goodsInfoId;
    @ApiModelProperty(value = "购买数量")
    private Integer buyNum;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "产品or行业, 1产品、2行业")
    @NonNull
    private Integer directoryId;
    @ApiModelProperty(value = "商品最小规格id")
    private Set<Integer> mallSpecIds;
    @ApiModelProperty(value = "收货地址id")
    private Integer userAddressId;
}
