package com.mmc.oms.model.dto.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * author:zhenjie
 * Date:2022/10/19
 * time:15:27
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.mall.dto.OrderGoodsProdDetailDTO", description = "订单最小sku信息")
public class OrderGoodsProdDetailDTO implements Serializable {
    private static final long serialVersionUID = 2079521148328016486L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "二级订单的id")
    private Integer orderGoodsProdId;
    @ApiModelProperty(value = "购物车详情id")
    private Integer mallProdShopCarDetailId;
    @ApiModelProperty(value = "商品skuId")
    private Integer mallProdSkuInfoId;
    @ApiModelProperty(value = "商品sku详情id")
    private Integer mallProdSkuInfoSpecId;
    @ApiModelProperty(value = "产品规格id")
    private Integer productSpecId;
    @ApiModelProperty(value = "产品规格名称")
    private String specName;
    @ApiModelProperty(value = "产品规格图片")
    private String prodSkuSpecImage;
    @ApiModelProperty(value = "料号")
    private String partNo;
    @ApiModelProperty(value = "版本描述")
    private String versionDesc;
    @ApiModelProperty(value = "购买数量")
    private Integer buyNum;
    @ApiModelProperty(value = "单价")
    private BigDecimal unitPrice;
    @ApiModelProperty(value = "总价格")
    private BigDecimal skuSpecAmount;
    @ApiModelProperty(value = "商品产品类型名称")
    private String goodsTypeName;
    @ApiModelProperty(value = "产品名称")
    private String productName;
    @ApiModelProperty(value = "型号")
    private String model;
    @ApiModelProperty(value = "品牌")
    private String productBrand;
    @ApiModelProperty(value = "品牌Id")
    private Integer brandInfoId;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "是否有效")
    private Boolean valid;

    @ApiModelProperty(value = "是否删除")
    private Integer skuInfoDeleted;
    @ApiModelProperty(value = "是否删除")
    private Integer skuSpecDeleted;
    @ApiModelProperty(value = "是否删除")
    private Integer specDeleted;
    @ApiModelProperty(value = "单位名称")
    private String unitName;

}
